// RWS
definition module osmenu

from ostoolbox import OSToolbox
from intrface import HMENU, HITEM
from oswindow import OSWindowPtr
from StdInt import ==


//	Types for menus and menu elements:
::	MenuBar
	=	NoMenuBar
	|	MenuBar OSMenuBar
::	OSMenuBar
::	OSMenu			:== HMENU
::	OSMenuItem		:== HITEM
::	OSMenuSeparator	:== HITEM

//	Dummy values:
OSNoMenu			:== 0
OSNoMenuItem		:== 0
OSNoMenuSeparator	:== 0


/*	Enabling and disabling of menus and menu elements:
	OS(Dis/En)ableMenu index menubar
		(dis/en)ables the top-level menu at the zero based index position of the menubar.
	OS(Dis/En)ableMenuItem parentMenu menuitem 
		(dis/en)ables the menuitem that is part of the parentMenu.
*/
OSDisableMenu		:: !Int !OSMenuBar		!*OSToolbox -> *OSToolbox
OSEnableMenu		:: !Int !OSMenuBar		!*OSToolbox -> *OSToolbox
OSEnableMenuItem	:: !OSMenu !OSMenuItem	!*OSToolbox -> *OSToolbox
OSDisableMenuItem	:: !OSMenu !OSMenuItem	!*OSToolbox -> *OSToolbox


/*	Changing and updating the menubar:
	OSMenuBarNew
		creates a new menubar that is needed to create top-level menus in.
	DrawMenuBar
		redraws the menubar. This must be done after every change of the menubar (adding/removing).
	OSMenuBarClear
		clears the menubar.
	OSMenuBarSet
		dunno??
	OSMenuBarRemove menubar
		disposes the menubar.
	OSMenuInsert index menuNr title menubar 
		creates and inserts a new top-level menu at the indicated zero based index position.
		The new menu has the given title and the menuNr as retrieved by OSNewMenuNr (below).
	OSSubMenuInsert index menuNr title parentMenu 
		creates and inserts a new submenu at the indicated zero based index position.
		The new submenu has the given title and the menuNr as retrieved by OSNewSubMenuNr (below).
	OSMenuRemove menu menubar
		removes the indicated menu both 'logically' and 'physically' from the menubar.
	OSSubMenuRemove submenu parentMenu
		removes the submenu both 'logically' and 'physically' from the parentMenu.
*/
OSMenuBarNew		:: !*OSToolbox -> (!OSMenuBar,!*OSToolbox)
DrawMenuBar			:: !*OSToolbox -> *OSToolbox
OSMenuBarClear		:: !*OSToolbox -> *OSToolbox
OSMenuBarSet		:: !OSMenuBar							!*OSToolbox -> (!OSMenuBar, !*OSToolbox)
OSMenuBarRemove		:: !OSMenuBar							!*OSToolbox -> *OSToolbox
OSMenuInsert		:: !Int !OSMenuNr !{#Char} !OSMenuBar	!*OSToolbox -> (!OSMenu,!OSMenuBar,	!*OSToolbox)
OSSubMenuInsert		:: !Int !OSMenuNr !{#Char} !OSMenu		!*OSToolbox -> (!OSMenu,!OSMenu,	!*OSToolbox)
OSMenuRemove		:: !OSMenu !OSMenuBar					!*OSToolbox -> (!OSMenuBar,			!*OSToolbox)
OSSubMenuRemove		:: !OSMenu !OSMenu						!*OSToolbox -> (!OSMenu,			!*OSToolbox)


/*	Changing a (sub)menus and menu elements:
	OSAppendMenuItem index menu title able mark key
		adds a new menuitem to the given menu at the indicated zero based index position.
		The menuitem has the given title, selectstate, markstate, and shortcut key.
	OSAppendMenuSeparator index menu
		adds a new menuseparator to the given menu at the indicated zero based index position.
	OSChangeMenuTitle menubar menu title
		sets the new title of the indicated top-level menu in the menubar.
	OSChangeMenuItemTitle parentMenu menuitem title
		sets the new title of the indicated menuitem/submenu contained in the parentMenu.
	OSMenuItemCheck check parentMenu menuitem
		marks the item iff check of the indicated menuitem contained in the parentMenu.
	OSMenuRemoveItem menuitem parentMenu
		removes the menuitem 'logically' from the indicated parentMenu. The menuitem is not destroyed. CHECK APPLICATIONS!!
*/
OSAppendMenuItem		:: !Int !OSMenu !{#Char} !Bool !Bool !Char	!*OSToolbox -> (!OSMenuItem,	 !OSMenu,!*OSToolbox)
OSAppendMenuSeparator	:: !Int !OSMenu								!*OSToolbox -> (!OSMenuSeparator,!OSMenu,!*OSToolbox)
OSChangeMenuTitle		:: !OSMenuBar !OSMenu !{#Char}				!*OSToolbox -> *OSToolbox
OSChangeMenuItemTitle	:: !OSMenu !OSMenuItem !{#Char}				!*OSToolbox -> *OSToolbox
OSMenuItemCheck			:: !Bool !OSMenu !OSMenuItem				!*OSToolbox -> *OSToolbox
OSMenuRemoveItem		:: !OSMenuItem !OSMenu						!*OSToolbox -> (!OSMenu,!*OSToolbox)


/*	Validation of (sub)menu (element) attributes:
*/
// OSValidateMenuItemTitle :: !{#Char} -> !{#Char}
OSValidateMenuItemTitle title :== title


//	PA: two new functions that generate free OS ids for menus and sub menus.
//	If the functions fail, then the Bool result is False, and the Int result is 0. Do not continue to create the (sub)menu.
::	OSMenuNr	:== Int
::	OSSubMenuNr	:== Int

OSNewMenuNr		:: !*OSToolbox -> (!Bool,!OSMenuNr,   !*OSToolbox)
OSNewSubMenuNr	:: !*OSToolbox -> (!Bool,!OSSubMenuNr,!*OSToolbox)


//	PA: the following definitions seem not to be used.
// RWS +++ match with: (menu, itemnr, ositem)
// OSMatchMenuItem :: !Int !OSMenuItem -> Bool
OSMatchMenuItem i v
	:==	i == v

InsertMenu :: !OSMenu !Int !*OSToolbox -> *OSToolbox
OSAppendSubmenu :: !Int !OSMenu !{#Char} !*OSToolbox -> (!OSMenu, !*OSToolbox)
// DelMenuItem :: !OSMenu !Int !*OSToolbox -> *OSToolbox
// CheckMenuItem :: !OSMenu !Int !*OSToolbox -> *OSToolbox
DisposeMenu :: !OSMenu !*OSToolbox -> *OSToolbox
